import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:place_candle', {
        onPlayerInteract({ block, player }) {
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const noCandle = block.permutation.withState('v360:candle_bit', false)
            const candle = block.permutation.withState('v360:candle_bit', true)
            if (selectedItem?.typeId === 'minecraft:candle' && noCandle) {
                block.setPermutation(candle)
                block.dimension.playSound('use.candle', block.location)
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s minecraft:candle 0 1`)
                }
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:candlestick_flame_we', {
        onTick({ block }) {
            const { x, y, z } = block.location
            if (block.permutation.withState('v360:light_bit', true)) {
                block.dimension.runCommand(`particle minecraft:candle_flame_particle ${x + 0.5} ${y + 0.94} ${z + 0.5}`)
                block.dimension.runCommand(`particle minecraft:candle_flame_particle ${x} ${y + 0.94} ${z + 0.31}`)
                block.dimension.runCommand(`particle minecraft:candle_flame_particle ${x} ${y + 0.94} ${z + 0.69}`)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:candlestick_flame_ns', {
        onTick({ block }) {
            const { x, y, z } = block.location
            if (block.permutation.withState('v360:light_bit', true)) {
                block.dimension.runCommand(`particle minecraft:candle_flame_particle ${x + 0.5} ${y + 0.94} ${z + 0.5}`)
                block.dimension.runCommand(`particle minecraft:candle_flame_particle ${x + 0.31} ${y + 0.94} ${z}`)
                block.dimension.runCommand(`particle minecraft:candle_flame_particle ${x + 0.69} ${y + 0.94} ${z}`)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:candlestick_flame_up', {
        onPlayerInteract({ block, player }) {
            const item = player.getComponent('equippable')
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const noFlame = block.permutation.withState('v360:light_bit', false)
            const flame = block.permutation.withState('v360:light_bit', true)
            const candle = block.permutation.withState('v360:candle_bit', true)
            if (selectedItem?.typeId === 'minecraft:flint_and_steel' && candle && noFlame) {
                block.setPermutation(flame)
                block.dimension.playSound('fire.ignite', block.location)
                const inventory = player.getComponent('inventory').container
                const damage = selectedItem.getComponent("durability").damage
                const durability = selectedItem.getComponent("durability").maxDurability
                if (damage >= durability) {
                    inventory.setItem(player.selectedSlot, null)
                    player.playSound("random.break");
                    return;
                }
                else {
                    selectedItem.getComponent("durability").damage += 1
                    item.setEquipment('Mainhand', selectedItem)
                }
            }
            else if (selectedItem?.typeId === 'minecraft:fire_charge') {
                block.setPermutation(flame)
                block.dimension.playSound('mob.ghast.fireball', block.location)
                if (player.getGameMode() !== 'creative') {
                    player.runCommand(`clear @s minecraft:fire_charge 0 1`)
                }
            }
            else if (selectedItem?.getComponent("minecraft:enchantable").getEnchantment('fire_aspect')) {
                block.setPermutation(flame)
                block.dimension.playSound('fire.ignite', block.location)
            }
        }
    })
})